{version 1.2}
Unit nodes;

Interface

uses crt;


const LONGSTRING=640;
      T_DIRS:array[1..11] of string=('southwest','south','southeast',
      'west','','east','northwest','north','northeast','down','up');
      T_DIRS_SHORT:array[1..11] of string=('sw','s','se','w','','e','nw'
      ,'n','ne','down','up');
      N_DIRS_X:array[1..11] of shortint=(-1,0,1,-1,0,1,-1,0,1,0,0);
      N_DIRS_Y:array[1..11] of shortint=(-1,-1,-1,0,0,0,1,1,1,0,0);
      N_DIRS_Z:array[1..11] of shortint=(0,0,0,0,0,0,0,0,0,-1,1);
      N_INVERT:array[1..11] of shortint=(9,8,7,6,5,4,3,2,1,11,10);
      yes=true;
      no=false;
      C_DIRS:array[1..11] of char=('/','|','\','-','X','-','\','|','/','u','d');


type  dbstring=record
        f_name:string;
        s_name:string;
      end;

      dnstring=record
        f_name:string;
        _to:integer;
      end;

      long_dsc=array[0..LONGSTRING-1] of byte;

      pnode=^node;
      node=object
         posx,posy,posz:integer;
         s_name:string;
         next:pnode;
         exits:array[1..20] of dbstring;
         items:array[0..29] of dnstring;
         descriptions:array[0..29] of long_dsc; {0- short descr. 1-longdescr}
         var_types:array[0..3] of string;
         transferred:boolean;
         function get_short:string;
      end;

      map=object
        first:pnode;
        modified:boolean;
        constructor init;
        destructor done;
        function addnode:pnode;
        procedure remnode(po:pnode);
        procedure chprop(po:pnode;dirs:array of byte;px,py,pz,zn:integer;fname:string;leave:boolean);
        procedure display(fx,fy:integer);
        function findnode(wx,wy,wz:integer):pnode;
        procedure purify;
        function found(s:string):pnode;
        procedure generate_files(ext:string;spec:pnode);
        function prev(po:pnode):pnode;
        procedure lonely(po:pnode);

        procedure select(po:pnode);
        procedure unselect;
        procedure trtm(dir:byte);
      end;


Implementation


constructor map.init;
begin
  first:=nil;
  modified:=false;
end;

destructor map.done;
begin
  while not (first=nil) do remnode(first);
end;

function map.addnode:pnode;
var pom:pnode;
    a,b:integer;
begin
  new(pom);
  if first=nil then
  begin
    first:=pom;
    first^.next:=nil;
  end else
  begin
    pom^.next:=first;
    first:=pom;
  end;
  addnode:=pom;
  modified:=true;
  pom^.s_name:='';
  for a:=1 to 20 do pom^.exits[a].s_name:='';
  for a:=1 to 20 do pom^.exits[a].f_name:='';
  for a:=1 to 11 do pom^.exits[a].f_name:=T_DIRS[a];
  for b:=0 to 29 do
    for a:=0 to LONGSTRING-1 do pom^.descriptions[b,a]:=0;
  for a:=0 to 29 do begin pom^.items[a].f_name:='';pom^.items[a]._to:=0; end;
  for a:=0 to 3 do pom^.var_types[a]:='';
  pom^.transferred:=NO;
end;

function map.findnode(wx,wy,wz:integer):pnode;
var bot:pnode;
Begin

  findnode:=nil;
  bot:=first;
  while bot<>nil do
  begin
     if ((bot^.posz=wz) and (bot^.posx=wx) and (bot^.posy=wy)) then begin findnode:=bot;exit; end;
     bot:=bot^.next;
  end;
End;

function map.prev(po:pnode):pnode;
var bot:pnode;
Begin
  if po=nil then exit;
  if first^.next=nil then exit;
  bot:=first;
  while (bot^.next<>nil) and (bot^.next<>po) do bot:=bot^.next;
  prev:=bot;
ENd;

function map.found(s:string):pnode;
var bot:pnode;
begin
  found:=nil;
  bot:=first;
  while bot<>nil do
  begin
     if (bot^.s_name=s) then begin found:=bot;exit; end;
     bot:=bot^.next;
  end;
end;


procedure map.remnode(po:pnode);
var pom,pom2:pnode;
    a:integer;
begin
  if po=nil then exit;
  if first=nil then exit;
  pom:=po;
  if pom=first then
  begin
    if first^.next=nil then
    begin
      dispose(pom);
      first:=nil;
    end else
    begin
      first:=first^.next;
      dispose(pom);
    end;

  end else
  begin
    pom2:=prev(pom);
    pom2^.next:=pom^.next;
    dispose(pom);
  end;
end;

procedure map.chprop(po:pnode;dirs:array of byte;px,py,pz,zn:integer;fname:string;leave:boolean);
var a:integer;
    pom:pnode;
begin
  pom:=nil;
  po^.s_name:=fname;
  po^.posx:=px;
  po^.posy:=py;
  po^.posz:=pz;
  for a:=1 to 11 do if (a<>5) then
    begin
      pom:=findnode(px+N_DIRS_X[a],py+N_DIRS_Y[a],pz+N_DIRS_Z[a]);

      if pom<>nil then if pom^.exits[N_INVERT[a]].s_name='void' then
      begin

        pom^.exits[N_INVERT[a]].s_name:=po^.s_name;
        po^.exits[a].s_name:=pom^.s_name;
      end;

      if not leave then
      begin
        if (dirs[a]<>1) and (po^.exits[a].s_name<>'') then
        begin
          po^.exits[a].s_name:='';
          pom^.exits[N_INVERT[a]].s_name:=''
        end;
      end else
      begin
        if (pom=nil) and (po^.exits[a].s_name='void') then
        begin
          po^.exits[a].s_name:='';
        end;
      end;

      if dirs[a]=1 then
      begin

        if pom<>nil then
        begin
          po^.exits[a].s_name:=pom^.s_name;
          pom^.exits[N_INVERT[a]].s_name:=po^.s_name;
        end else po^.exits[a].s_name:='void';
      end;

    end;
    modified:=true;
end;



procedure map.display(fx,fy:integer);
var pole:array[0..79,0..24] of word;
    pompole:array[0..24,0..79] of word;
    bot:pnode;
    tx,ty:integer;
    a,b:integer;
    znak:byte;
begin
  for a:=0 to 79 do for b:=0 to 24 do pole[a,b]:=0;
  bot:=first;
  while bot<>nil do begin
     if (bot^.posx>fx) and (bot^.posx<fx+39) and
        (bot^.posy>fy) and (bot^.posy<fy+13) then begin
           tx:=(bot^.posx-fx)*2-2;
           ty:=(-bot^.posy+fy)*2+0;
           pole[tx,ty]:=ord('*');
           if bot^.transferred=true then pole[tx,ty]:=pole[tx,ty]+2 shl 8;
           for b:=1 to 9 do
           begin

             znak:=255;
             if bot^.exits[b].s_name<>'' then znak:=ord(C_DIRS[b]);
             if bot^.exits[b].s_name='void' then znak:=ord('.');
             if znak<>255 then begin
               if ((pole[tx+N_DIRS_X[b],ty-N_DIRS_Y[b]]=ord('\')) and
                 ( znak=ord('/')))or
                  ((pole[tx+N_DIRS_X[b],ty-N_DIRS_Y[b]]=ord('/'))
                  and (znak=ord('\'))) then znak:=ord('X');
               pole[tx+N_DIRS_X[b],ty-N_DIRS_Y[b]]:=znak;
             end;
           end;
        end;
     bot:=bot^.next;
  end;
  for a:=0 to 79 do for b:=0 to 24 do begin
    if pole[a,b] shr 8=0 then pompole[b,a]:=pole[a,b]+ 7 shl 8 else
    pompole[b,a]:=pole[a,b];
  end;
  move(pompole,mem[segb800:0],4000);
end;

function node.get_short:string;
var s:string;
    a:integer;
Begin
  s[0]:=chr(80);
  for a:=1 to 80 do s[a]:=chr(descriptions[0][a-1]);
  get_short:=s;
End;


procedure map.purify{removes "void" connections};
var bot:pnode;
    var a:integer;
Begin
  bot:=first;
  while bot<>nil do
  begin
    for a:=1 to 20 do if bot^.exits[a].s_name='void' then bot^.exits[a].s_name:='';
    bot:=bot^.next;
  end;
End;


procedure map.lonely(po:pnode);
var a:integer;
    pom2:pnode;
Begin
  for a:=1 to 11 do
  begin
    pom2:=findnode(po^.posx+N_DIRS_X[a],
                   po^.posy+N_DIRS_Y[a],
                   po^.posz+N_DIRS_Z[a]);
    if (po^.exits[a].s_name<>'') and (po^.exits[a].s_name<>'void') and (pom2<>nil)
      then if pom2^.exits[N_INVERT[a]].s_name<>'' then
      begin
        pom2^.exits[N_INVERT[a]].s_name:='void';
      end;
  end;
  for a:=1 to 20 do po^.exits[a].s_name:='';
End;

procedure map.select(po:pnode);
var changed:integer;
    bot,pom:pnode;
    a:integer;

Begin
  if po=nil then exit;
  po^.transferred:=true;

  repeat
  changed:=0;
  bot:=first;
  while bot<>nil do
  begin
    if not bot^.transferred then
      for a:=1 to 20 do
      begin
        if (bot^.exits[a].s_name<>'void') and (bot^.exits[a].s_name<>'') then
          begin
            pom:=found(bot^.exits[a].s_name);
            if (pom<>nil) and (pom^.transferred) then
            begin
              inc(changed);
              bot^.transferred:=true;
            end;
          end;
      end;

    bot:=bot^.next;
  end;
  until changed=0;
End;

procedure map.unselect;
var bot:pnode;
Begin
  bot:=first;
  while bot<>nil do
  begin
    bot^.transferred:=false;
    bot:=bot^.next;
  end;
End;

procedure map.trtm(dir:byte);
var blocked:integer;
    pom,bot:pnode;
Begin
  blocked:=0;
  bot:=first;
  while bot<>nil do
  begin
    pom:=findnode(bot^.posx+N_DIRS_X[dir],
                  bot^.posy+N_DIRS_Y[dir],
                  bot^.posz+N_DIRS_Z[dir]);
    if (bot^.transferred) and (pom<>nil) and (not pom^.transferred) then inc(blocked);
    bot:=bot^.next;
  end;
  if blocked=0 then
  begin
    bot:=first;
    while bot<>nil do
    begin
      if bot^.transferred then
      begin
        bot^.posx:=bot^.posx+N_DIRS_X[dir];
        bot^.posy:=bot^.posy+N_DIRS_Y[dir];
        bot^.posz:=bot^.posz+N_DIRS_Z[dir];
      end;
      bot:=bot^.next;
    end;
  end;
ENd;


procedure map.generate_files(ext:string;spec:pnode);
var f:text;
    bot:pnode;
    a:integer;

  procedure deposit_des(work:long_dsc;reformat,crlf:boolean);
  var s:string;
      a,b,c:integer;
  Begin
    for a:=0 to LONGSTRING-1 do if work[a]=0 then work[a]:=32;
    case reformat of
      true:begin
             clrscr;
             a:=0;b:=0;c:=0;
             repeat
               if a<>0 then writeln(f,'');
               while ((work[a]=32) and (a<>LONGSTRING-1)) do inc(a);
               if a=LONGSTRING-1 then exit;
               b:=a;a:=a+79;if a>LONGSTRING-1 then a:=LONGSTRING-1;
               if not ((work[a]=32) and (a<>LONGSTRING-1))
               then while work[a]<>32 do dec(a);
               s[0]:=chr(a-b);for c:=b to a do s[c-b+1]:=chr(work[c]);
               c:=ord(s[0]);while (s[c]=' ') do dec(c);
               s[0]:=chr(c);
               write(f,'"'+s+' "');
             until a=LONGSTRING-1;
           end;
      false:begin
              a:=LONGSTRING-1;
              while (work[a]=0) and (a<>0) do dec(a);
              if a=0 then exit;
              for b:=0 to a div 80 do
              begin
                s[0]:=chr(80);for a:=0 to 79 do s[a+1]:=chr(work[b*80+a]);
                a:=ord(s[0]);while (s[a]=' ') do dec(a);
                s[0]:=chr(a);
                if crlf then writeln(f,'"'+s+' "') else  write(f,'"'+s+' "');
              end;
              s[0]:=chr(a mod 80);
              for b:=0 to a mod 80 do s[a+1]:=chr(work[a div 80*80+b]);
              a:=ord(s[0]);while (s[a]=' ') do dec(a);
              s[0]:=chr(a);
              if crlf then writeln(f,'"'+s+' "') else  write(f,'"'+s+' "');
            end;
    end
  end;

  function void(work:long_dsc):integer;
  var a:integer;
  Begin
    a:=LONGSTRING-1;
    while ((work[a]=32) or (work[a]=0)) and (a>0) do dec(a);
    void:=a;
  ENd;

  procedure deposit_items(po:pnode);
  var a,b,c,n:integer;
      s:string;
  Begin

    for a:=2 to 29 do if void(po^.descriptions[a])<>0 then
    begin
      s:='({';
      n:=0;

      for b:=0 to 29 do if (po^.items[b]._to=a-2) and (po^.items[b].f_name<>'') then
        begin
          c:=ord(po^.items[b].f_name[0]);
          while (po^.items[b].f_name[c]=' ') do dec(c);
          po^.items[b].f_name[0]:=chr(c);
          if n=0 then s:=s+'"'+po^.items[b].f_name+'"' else
            s:=s+', '+'"'+po^.items[b].f_name+'"';
          inc(n);
        end;
      s:=s+'}) :';


      if n>0 then
      begin
        write(f,s);
        deposit_des(po^.descriptions[a],true,true);
        writeln(f,' ,');
      end;
    end;
  End;

  procedure deposit_exits(po:pnode;betw:string);
  var a:integer;
      s,s2:string;
  begin
    for a:=1 to 20 do if (po^.exits[a].f_name<>'') and
      (po^.exits[a].s_name<>'') then
    begin
      s:='';
      if betw<>'' then s2:=betw+'+' else s2:='';
      s:=s+'"'+po^.exits[a].f_name+'":'+s2+'"'+po^.exits[a].s_name+'",';
      writeln(f,s);
    end;
  end;

  procedure deposit_short_exits(po:pnode);
  var a:integer;
      s,s2:string;
  begin
    s:='';
    for a:=1 to 11 do if (po^.exits[a].f_name<>'') and
      (po^.exits[a].s_name<>'') then
    begin
      if s='' then s:=s+T_DIRS_SHORT[a] else
        s:=s+', '+T_DIRS_SHORT[a];
    end;
    write(f,s);
  end;

Begin
  if spec<>nil then bot:=spec else bot:=first;
  while bot<>nil do
  begin
    {    exits:array[1..20] of dbstring;
         items:array[0..29] of dnstring;
         descriptions:array[0..29] of long_dsc; 0- short descr. 1-longdescr
         var_types:array[0..3] of string;}

    assign(f,bot^.s_name+ext);
    rewrite(f);
    writeln(f,'#include <lib.h>');
    writeln(f,'#include <weather_types.h>');;
    writeln(f,'#include "leande.h"');;
    writeln(f,'');
    writeln(f,'');
    writeln(f,'inherit LIB_ROOM;');
    writeln(f,'');
    writeln(f,'');
    writeln(f,'protected void create() {');
    writeln(f,'   room::create();');

    writeln(f,'   SetAreaType('+bot^.var_types[0]+');');
    writeln(f,'   SetAreaName('+bot^.var_types[1]+');');
    writeln(f,'   SetRainType('+bot^.var_types[2]+');');
    writeln(f,'   SetClimate('+bot^.var_types[3]+');');
    writeln(f,'   SetAmbientLight(40);');

    write  (f,'   SetShort(');
      deposit_des(bot^.descriptions[0],true,false);writeln(f,');');
    write  (f,'   SetLong(');
      deposit_des(bot^.descriptions[1],true,true);writeln(f,');');

    writeln(f,'   SetItems( ([');
      deposit_items(bot);
    writeln(f,']) );');


    writeln(f,'SetListen( ([]) );');
    writeln(f,'SetSmell( ([]) );');
    writeln(f,'SetEnters( ([]) );');
    writeln(f,'SetRead( ([]) );');
    writeln(f,'SetExits ( ([');
      deposit_exits(bot,'__DIR__');   {tady misto __DIR__ dopiste variable
      oznacujici rel.cestu k vasemo home adr.}
    writeln(f,'      ]) );');
    write(f,'SetObviousExits ("');
      deposit_short_exits(bot);
    writeln(f,'");');

    writeln(f,'}');
    close(f);
    if spec=nil then bot:=bot^.next else bot:=nil;
  end;
End;


End.